# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .copy_app_request_body import CopyAppRequestBody


class CopyAppRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.app_token: Optional[str] = None
        self.request_body: Optional[CopyAppRequestBody] = None

    @staticmethod
    def builder() -> "CopyAppRequestBuilder":
        return CopyAppRequestBuilder()


class CopyAppRequestBuilder(object):

    def __init__(self) -> None:
        copy_app_request = CopyAppRequest()
        copy_app_request.http_method = HttpMethod.POST
        copy_app_request.uri = "/open-apis/bitable/v1/apps/:app_token/copy"
        copy_app_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._copy_app_request: CopyAppRequest = copy_app_request

    def app_token(self, app_token: str) -> "CopyAppRequestBuilder":
        self._copy_app_request.app_token = app_token
        self._copy_app_request.paths["app_token"] = str(app_token)
        return self

    def request_body(self, request_body: CopyAppRequestBody) -> "CopyAppRequestBuilder":
        self._copy_app_request.request_body = request_body
        self._copy_app_request.body = request_body
        return self

    def build(self) -> CopyAppRequest:
        return self._copy_app_request
