# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .app_role_member import AppRoleMember


class CreateAppRoleMemberRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.member_id_type: Optional[str] = None
        self.app_token: Optional[str] = None
        self.role_id: Optional[str] = None
        self.request_body: Optional[AppRoleMember] = None

    @staticmethod
    def builder() -> "CreateAppRoleMemberRequestBuilder":
        return CreateAppRoleMemberRequestBuilder()


class CreateAppRoleMemberRequestBuilder(object):

    def __init__(self) -> None:
        create_app_role_member_request = CreateAppRoleMemberRequest()
        create_app_role_member_request.http_method = HttpMethod.POST
        create_app_role_member_request.uri = "/open-apis/bitable/v1/apps/:app_token/roles/:role_id/members"
        create_app_role_member_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._create_app_role_member_request: CreateAppRoleMemberRequest = create_app_role_member_request

    def member_id_type(self, member_id_type: str) -> "CreateAppRoleMemberRequestBuilder":
        self._create_app_role_member_request.member_id_type = member_id_type
        self._create_app_role_member_request.add_query("member_id_type", member_id_type)
        return self

    def app_token(self, app_token: str) -> "CreateAppRoleMemberRequestBuilder":
        self._create_app_role_member_request.app_token = app_token
        self._create_app_role_member_request.paths["app_token"] = str(app_token)
        return self

    def role_id(self, role_id: str) -> "CreateAppRoleMemberRequestBuilder":
        self._create_app_role_member_request.role_id = role_id
        self._create_app_role_member_request.paths["role_id"] = str(role_id)
        return self

    def request_body(self, request_body: AppRoleMember) -> "CreateAppRoleMemberRequestBuilder":
        self._create_app_role_member_request.request_body = request_body
        self._create_app_role_member_request.body = request_body
        return self

    def build(self) -> CreateAppRoleMemberRequest:
        return self._create_app_role_member_request
