# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .app_role import AppRole


class CreateAppRoleRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.app_token: Optional[str] = None
        self.request_body: Optional[AppRole] = None

    @staticmethod
    def builder() -> "CreateAppRoleRequestBuilder":
        return CreateAppRoleRequestBuilder()


class CreateAppRoleRequestBuilder(object):

    def __init__(self) -> None:
        create_app_role_request = CreateAppRoleRequest()
        create_app_role_request.http_method = HttpMethod.POST
        create_app_role_request.uri = "/open-apis/bitable/v1/apps/:app_token/roles"
        create_app_role_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._create_app_role_request: CreateAppRoleRequest = create_app_role_request

    def app_token(self, app_token: str) -> "CreateAppRoleRequestBuilder":
        self._create_app_role_request.app_token = app_token
        self._create_app_role_request.paths["app_token"] = str(app_token)
        return self

    def request_body(self, request_body: AppRole) -> "CreateAppRoleRequestBuilder":
        self._create_app_role_request.request_body = request_body
        self._create_app_role_request.body = request_body
        return self

    def build(self) -> CreateAppRoleRequest:
        return self._create_app_role_request
