# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .app_table_field import AppTableField


class CreateAppTableFieldRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.client_token: Optional[str] = None
        self.app_token: Optional[str] = None
        self.table_id: Optional[str] = None
        self.request_body: Optional[AppTableField] = None

    @staticmethod
    def builder() -> "CreateAppTableFieldRequestBuilder":
        return CreateAppTableFieldRequestBuilder()


class CreateAppTableFieldRequestBuilder(object):

    def __init__(self) -> None:
        create_app_table_field_request = CreateAppTableFieldRequest()
        create_app_table_field_request.http_method = HttpMethod.POST
        create_app_table_field_request.uri = "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/fields"
        create_app_table_field_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._create_app_table_field_request: CreateAppTableFieldRequest = create_app_table_field_request

    def client_token(self, client_token: str) -> "CreateAppTableFieldRequestBuilder":
        self._create_app_table_field_request.client_token = client_token
        self._create_app_table_field_request.add_query("client_token", client_token)
        return self

    def app_token(self, app_token: str) -> "CreateAppTableFieldRequestBuilder":
        self._create_app_table_field_request.app_token = app_token
        self._create_app_table_field_request.paths["app_token"] = str(app_token)
        return self

    def table_id(self, table_id: str) -> "CreateAppTableFieldRequestBuilder":
        self._create_app_table_field_request.table_id = table_id
        self._create_app_table_field_request.paths["table_id"] = str(table_id)
        return self

    def request_body(self, request_body: AppTableField) -> "CreateAppTableFieldRequestBuilder":
        self._create_app_table_field_request.request_body = request_body
        self._create_app_table_field_request.body = request_body
        return self

    def build(self) -> CreateAppTableFieldRequest:
        return self._create_app_table_field_request
