# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .create_app_table_request_body import CreateAppTableRequestBody


class CreateAppTableRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.app_token: Optional[str] = None
        self.request_body: Optional[CreateAppTableRequestBody] = None

    @staticmethod
    def builder() -> "CreateAppTableRequestBuilder":
        return CreateAppTableRequestBuilder()


class CreateAppTableRequestBuilder(object):

    def __init__(self) -> None:
        create_app_table_request = CreateAppTableRequest()
        create_app_table_request.http_method = HttpMethod.POST
        create_app_table_request.uri = "/open-apis/bitable/v1/apps/:app_token/tables"
        create_app_table_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._create_app_table_request: CreateAppTableRequest = create_app_table_request

    def app_token(self, app_token: str) -> "CreateAppTableRequestBuilder":
        self._create_app_table_request.app_token = app_token
        self._create_app_table_request.paths["app_token"] = str(app_token)
        return self

    def request_body(self, request_body: CreateAppTableRequestBody) -> "CreateAppTableRequestBuilder":
        self._create_app_table_request.request_body = request_body
        self._create_app_table_request.body = request_body
        return self

    def build(self) -> CreateAppTableRequest:
        return self._create_app_table_request
