# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .req_view import ReqView


class CreateAppTableViewRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.app_token: Optional[str] = None
        self.table_id: Optional[str] = None
        self.request_body: Optional[ReqView] = None

    @staticmethod
    def builder() -> "CreateAppTableViewRequestBuilder":
        return CreateAppTableViewRequestBuilder()


class CreateAppTableViewRequestBuilder(object):

    def __init__(self) -> None:
        create_app_table_view_request = CreateAppTableViewRequest()
        create_app_table_view_request.http_method = HttpMethod.POST
        create_app_table_view_request.uri = "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/views"
        create_app_table_view_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._create_app_table_view_request: CreateAppTableViewRequest = create_app_table_view_request

    def app_token(self, app_token: str) -> "CreateAppTableViewRequestBuilder":
        self._create_app_table_view_request.app_token = app_token
        self._create_app_table_view_request.paths["app_token"] = str(app_token)
        return self

    def table_id(self, table_id: str) -> "CreateAppTableViewRequestBuilder":
        self._create_app_table_view_request.table_id = table_id
        self._create_app_table_view_request.paths["table_id"] = str(table_id)
        return self

    def request_body(self, request_body: ReqView) -> "CreateAppTableViewRequestBuilder":
        self._create_app_table_view_request.request_body = request_body
        self._create_app_table_view_request.body = request_body
        return self

    def build(self) -> CreateAppTableViewRequest:
        return self._create_app_table_view_request
