# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class DeleteAppRoleRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.app_token: Optional[str] = None
        self.role_id: Optional[str] = None

    @staticmethod
    def builder() -> "DeleteAppRoleRequestBuilder":
        return DeleteAppRoleRequestBuilder()


class DeleteAppRoleRequestBuilder(object):

    def __init__(self) -> None:
        delete_app_role_request = DeleteAppRoleRequest()
        delete_app_role_request.http_method = HttpMethod.DELETE
        delete_app_role_request.uri = "/open-apis/bitable/v1/apps/:app_token/roles/:role_id"
        delete_app_role_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._delete_app_role_request: DeleteAppRoleRequest = delete_app_role_request

    def app_token(self, app_token: str) -> "DeleteAppRoleRequestBuilder":
        self._delete_app_role_request.app_token = app_token
        self._delete_app_role_request.paths["app_token"] = str(app_token)
        return self

    def role_id(self, role_id: str) -> "DeleteAppRoleRequestBuilder":
        self._delete_app_role_request.role_id = role_id
        self._delete_app_role_request.paths["role_id"] = str(role_id)
        return self

    def build(self) -> DeleteAppRoleRequest:
        return self._delete_app_role_request
