# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class DeleteRecord(object):
    _types = {
        "deleted": bool,
        "record_id": str,
    }

    def __init__(self, d=None):
        self.deleted: Optional[bool] = None
        self.record_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "DeleteRecordBuilder":
        return DeleteRecordBuilder()


class DeleteRecordBuilder(object):
    def __init__(self) -> None:
        self._delete_record = DeleteRecord()

    def deleted(self, deleted: bool) -> "DeleteRecordBuilder":
        self._delete_record.deleted = deleted
        return self

    def record_id(self, record_id: str) -> "DeleteRecordBuilder":
        self._delete_record.record_id = record_id
        return self

    def build(self) -> "DeleteRecord":
        return self._delete_record
