# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .condition import Condition


class FilterInfo(object):
    _types = {
        "conjunction": str,
        "conditions": List[Condition],
    }

    def __init__(self, d=None):
        self.conjunction: Optional[str] = None
        self.conditions: Optional[List[Condition]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "FilterInfoBuilder":
        return FilterInfoBuilder()


class FilterInfoBuilder(object):
    def __init__(self) -> None:
        self._filter_info = FilterInfo()

    def conjunction(self, conjunction: str) -> "FilterInfoBuilder":
        self._filter_info.conjunction = conjunction
        return self

    def conditions(self, conditions: List[Condition]) -> "FilterInfoBuilder":
        self._filter_info.conditions = conditions
        return self

    def build(self) -> "FilterInfo":
        return self._filter_info
