# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .app_role import AppRole


class ListAppRoleResponseBody(object):
    _types = {
        "items": List[AppRole],
        "page_token": str,
        "has_more": bool,
        "total": int,
    }

    def __init__(self, d=None):
        self.items: Optional[List[AppRole]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        self.total: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListAppRoleResponseBodyBuilder":
        return ListAppRoleResponseBodyBuilder()


class ListAppRoleResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_app_role_response_body = ListAppRoleResponseBody()

    def items(self, items: List[AppRole]) -> "ListAppRoleResponseBodyBuilder":
        self._list_app_role_response_body.items = items
        return self

    def page_token(self, page_token: str) -> "ListAppRoleResponseBodyBuilder":
        self._list_app_role_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "ListAppRoleResponseBodyBuilder":
        self._list_app_role_response_body.has_more = has_more
        return self

    def total(self, total: int) -> "ListAppRoleResponseBodyBuilder":
        self._list_app_role_response_body.total = total
        return self

    def build(self) -> "ListAppRoleResponseBody":
        return self._list_app_role_response_body
