# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListAppTableFieldRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.view_id: Optional[str] = None
        self.text_field_as_array: Optional[bool] = None
        self.page_token: Optional[str] = None
        self.page_size: Optional[int] = None
        self.app_token: Optional[str] = None
        self.table_id: Optional[str] = None

    @staticmethod
    def builder() -> "ListAppTableFieldRequestBuilder":
        return ListAppTableFieldRequestBuilder()


class ListAppTableFieldRequestBuilder(object):

    def __init__(self) -> None:
        list_app_table_field_request = ListAppTableFieldRequest()
        list_app_table_field_request.http_method = HttpMethod.GET
        list_app_table_field_request.uri = "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/fields"
        list_app_table_field_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._list_app_table_field_request: ListAppTableFieldRequest = list_app_table_field_request

    def view_id(self, view_id: str) -> "ListAppTableFieldRequestBuilder":
        self._list_app_table_field_request.view_id = view_id
        self._list_app_table_field_request.add_query("view_id", view_id)
        return self

    def text_field_as_array(self, text_field_as_array: bool) -> "ListAppTableFieldRequestBuilder":
        self._list_app_table_field_request.text_field_as_array = text_field_as_array
        self._list_app_table_field_request.add_query("text_field_as_array", text_field_as_array)
        return self

    def page_token(self, page_token: str) -> "ListAppTableFieldRequestBuilder":
        self._list_app_table_field_request.page_token = page_token
        self._list_app_table_field_request.add_query("page_token", page_token)
        return self

    def page_size(self, page_size: int) -> "ListAppTableFieldRequestBuilder":
        self._list_app_table_field_request.page_size = page_size
        self._list_app_table_field_request.add_query("page_size", page_size)
        return self

    def app_token(self, app_token: str) -> "ListAppTableFieldRequestBuilder":
        self._list_app_table_field_request.app_token = app_token
        self._list_app_table_field_request.paths["app_token"] = str(app_token)
        return self

    def table_id(self, table_id: str) -> "ListAppTableFieldRequestBuilder":
        self._list_app_table_field_request.table_id = table_id
        self._list_app_table_field_request.paths["table_id"] = str(table_id)
        return self

    def build(self) -> ListAppTableFieldRequest:
        return self._list_app_table_field_request
