# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .app_table_field_for_list import AppTableFieldForList


class ListAppTableFieldResponseBody(object):
    _types = {
        "has_more": bool,
        "page_token": str,
        "total": int,
        "items": List[AppTableFieldForList],
    }

    def __init__(self, d=None):
        self.has_more: Optional[bool] = None
        self.page_token: Optional[str] = None
        self.total: Optional[int] = None
        self.items: Optional[List[AppTableFieldForList]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListAppTableFieldResponseBodyBuilder":
        return ListAppTableFieldResponseBodyBuilder()


class ListAppTableFieldResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_app_table_field_response_body = ListAppTableFieldResponseBody()

    def has_more(self, has_more: bool) -> "ListAppTableFieldResponseBodyBuilder":
        self._list_app_table_field_response_body.has_more = has_more
        return self

    def page_token(self, page_token: str) -> "ListAppTableFieldResponseBodyBuilder":
        self._list_app_table_field_response_body.page_token = page_token
        return self

    def total(self, total: int) -> "ListAppTableFieldResponseBodyBuilder":
        self._list_app_table_field_response_body.total = total
        return self

    def items(self, items: List[AppTableFieldForList]) -> "ListAppTableFieldResponseBodyBuilder":
        self._list_app_table_field_response_body.items = items
        return self

    def build(self) -> "ListAppTableFieldResponseBody":
        return self._list_app_table_field_response_body
