# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListAppTableRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.page_token: Optional[str] = None
        self.page_size: Optional[int] = None
        self.app_token: Optional[str] = None

    @staticmethod
    def builder() -> "ListAppTableRequestBuilder":
        return ListAppTableRequestBuilder()


class ListAppTableRequestBuilder(object):

    def __init__(self) -> None:
        list_app_table_request = ListAppTableRequest()
        list_app_table_request.http_method = HttpMethod.GET
        list_app_table_request.uri = "/open-apis/bitable/v1/apps/:app_token/tables"
        list_app_table_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._list_app_table_request: ListAppTableRequest = list_app_table_request

    def page_token(self, page_token: str) -> "ListAppTableRequestBuilder":
        self._list_app_table_request.page_token = page_token
        self._list_app_table_request.add_query("page_token", page_token)
        return self

    def page_size(self, page_size: int) -> "ListAppTableRequestBuilder":
        self._list_app_table_request.page_size = page_size
        self._list_app_table_request.add_query("page_size", page_size)
        return self

    def app_token(self, app_token: str) -> "ListAppTableRequestBuilder":
        self._list_app_table_request.app_token = app_token
        self._list_app_table_request.paths["app_token"] = str(app_token)
        return self

    def build(self) -> ListAppTableRequest:
        return self._list_app_table_request
