# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .app_table_view import AppTableView


class ListAppTableViewResponseBody(object):
    _types = {
        "items": List[AppTableView],
        "page_token": str,
        "has_more": bool,
        "total": int,
    }

    def __init__(self, d=None):
        self.items: Optional[List[AppTableView]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        self.total: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListAppTableViewResponseBodyBuilder":
        return ListAppTableViewResponseBodyBuilder()


class ListAppTableViewResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_app_table_view_response_body = ListAppTableViewResponseBody()

    def items(self, items: List[AppTableView]) -> "ListAppTableViewResponseBodyBuilder":
        self._list_app_table_view_response_body.items = items
        return self

    def page_token(self, page_token: str) -> "ListAppTableViewResponseBodyBuilder":
        self._list_app_table_view_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "ListAppTableViewResponseBodyBuilder":
        self._list_app_table_view_response_body.has_more = has_more
        return self

    def total(self, total: int) -> "ListAppTableViewResponseBodyBuilder":
        self._list_app_table_view_response_body.total = total
        return self

    def build(self) -> "ListAppTableViewResponseBody":
        return self._list_app_table_view_response_body
