# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .app_table_form_patched_field import AppTableFormPatchedField


class PatchAppTableFormFieldRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.app_token: Optional[str] = None
        self.table_id: Optional[str] = None
        self.form_id: Optional[str] = None
        self.field_id: Optional[str] = None
        self.request_body: Optional[AppTableFormPatchedField] = None

    @staticmethod
    def builder() -> "PatchAppTableFormFieldRequestBuilder":
        return PatchAppTableFormFieldRequestBuilder()


class PatchAppTableFormFieldRequestBuilder(object):

    def __init__(self) -> None:
        patch_app_table_form_field_request = PatchAppTableFormFieldRequest()
        patch_app_table_form_field_request.http_method = HttpMethod.PATCH
        patch_app_table_form_field_request.uri = "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/forms/:form_id/fields/:field_id"
        patch_app_table_form_field_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._patch_app_table_form_field_request: PatchAppTableFormFieldRequest = patch_app_table_form_field_request

    def app_token(self, app_token: str) -> "PatchAppTableFormFieldRequestBuilder":
        self._patch_app_table_form_field_request.app_token = app_token
        self._patch_app_table_form_field_request.paths["app_token"] = str(app_token)
        return self

    def table_id(self, table_id: str) -> "PatchAppTableFormFieldRequestBuilder":
        self._patch_app_table_form_field_request.table_id = table_id
        self._patch_app_table_form_field_request.paths["table_id"] = str(table_id)
        return self

    def form_id(self, form_id: str) -> "PatchAppTableFormFieldRequestBuilder":
        self._patch_app_table_form_field_request.form_id = form_id
        self._patch_app_table_form_field_request.paths["form_id"] = str(form_id)
        return self

    def field_id(self, field_id: str) -> "PatchAppTableFormFieldRequestBuilder":
        self._patch_app_table_form_field_request.field_id = field_id
        self._patch_app_table_form_field_request.paths["field_id"] = str(field_id)
        return self

    def request_body(self, request_body: AppTableFormPatchedField) -> "PatchAppTableFormFieldRequestBuilder":
        self._patch_app_table_form_field_request.request_body = request_body
        self._patch_app_table_form_field_request.body = request_body
        return self

    def build(self) -> PatchAppTableFormFieldRequest:
        return self._patch_app_table_form_field_request
