# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .patch_app_table_request_body import PatchAppTableRequestBody


class PatchAppTableRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.app_token: Optional[str] = None
        self.table_id: Optional[str] = None
        self.request_body: Optional[PatchAppTableRequestBody] = None

    @staticmethod
    def builder() -> "PatchAppTableRequestBuilder":
        return PatchAppTableRequestBuilder()


class PatchAppTableRequestBuilder(object):

    def __init__(self) -> None:
        patch_app_table_request = PatchAppTableRequest()
        patch_app_table_request.http_method = HttpMethod.PATCH
        patch_app_table_request.uri = "/open-apis/bitable/v1/apps/:app_token/tables/:table_id"
        patch_app_table_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._patch_app_table_request: PatchAppTableRequest = patch_app_table_request

    def app_token(self, app_token: str) -> "PatchAppTableRequestBuilder":
        self._patch_app_table_request.app_token = app_token
        self._patch_app_table_request.paths["app_token"] = str(app_token)
        return self

    def table_id(self, table_id: str) -> "PatchAppTableRequestBuilder":
        self._patch_app_table_request.table_id = table_id
        self._patch_app_table_request.paths["table_id"] = str(table_id)
        return self

    def request_body(self, request_body: PatchAppTableRequestBody) -> "PatchAppTableRequestBuilder":
        self._patch_app_table_request.request_body = request_body
        self._patch_app_table_request.body = request_body
        return self

    def build(self) -> PatchAppTableRequest:
        return self._patch_app_table_request
