# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .patch_app_table_view_request_body import PatchAppTableViewRequestBody


class PatchAppTableViewRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.app_token: Optional[str] = None
        self.table_id: Optional[str] = None
        self.view_id: Optional[str] = None
        self.request_body: Optional[PatchAppTableViewRequestBody] = None

    @staticmethod
    def builder() -> "PatchAppTableViewRequestBuilder":
        return PatchAppTableViewRequestBuilder()


class PatchAppTableViewRequestBuilder(object):

    def __init__(self) -> None:
        patch_app_table_view_request = PatchAppTableViewRequest()
        patch_app_table_view_request.http_method = HttpMethod.PATCH
        patch_app_table_view_request.uri = "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/views/:view_id"
        patch_app_table_view_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._patch_app_table_view_request: PatchAppTableViewRequest = patch_app_table_view_request

    def app_token(self, app_token: str) -> "PatchAppTableViewRequestBuilder":
        self._patch_app_table_view_request.app_token = app_token
        self._patch_app_table_view_request.paths["app_token"] = str(app_token)
        return self

    def table_id(self, table_id: str) -> "PatchAppTableViewRequestBuilder":
        self._patch_app_table_view_request.table_id = table_id
        self._patch_app_table_view_request.paths["table_id"] = str(table_id)
        return self

    def view_id(self, view_id: str) -> "PatchAppTableViewRequestBuilder":
        self._patch_app_table_view_request.view_id = view_id
        self._patch_app_table_view_request.paths["view_id"] = str(view_id)
        return self

    def request_body(self, request_body: PatchAppTableViewRequestBody) -> "PatchAppTableViewRequestBuilder":
        self._patch_app_table_view_request.request_body = request_body
        self._patch_app_table_view_request.body = request_body
        return self

    def build(self) -> PatchAppTableViewRequest:
        return self._patch_app_table_view_request
