# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class Person(object):
    _types = {
        "id": str,
        "name": str,
        "en_name": str,
        "email": str,
        "avatar_url": str,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.en_name: Optional[str] = None
        self.email: Optional[str] = None
        self.avatar_url: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "PersonBuilder":
        return PersonBuilder()


class PersonBuilder(object):
    def __init__(self) -> None:
        self._person = Person()

    def id(self, id: str) -> "PersonBuilder":
        self._person.id = id
        return self

    def name(self, name: str) -> "PersonBuilder":
        self._person.name = name
        return self

    def en_name(self, en_name: str) -> "PersonBuilder":
        self._person.en_name = en_name
        return self

    def email(self, email: str) -> "PersonBuilder":
        self._person.email = email
        return self

    def avatar_url(self, avatar_url: str) -> "PersonBuilder":
        self._person.avatar_url = avatar_url
        return self

    def build(self) -> "Person":
        return self._person
