# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class ReqApp(object):
    _types = {
        "name": str,
        "folder_token": str,
        "time_zone": str,
    }

    def __init__(self, d=None):
        self.name: Optional[str] = None
        self.folder_token: Optional[str] = None
        self.time_zone: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ReqAppBuilder":
        return ReqAppBuilder()


class ReqAppBuilder(object):
    def __init__(self) -> None:
        self._req_app = ReqApp()

    def name(self, name: str) -> "ReqAppBuilder":
        self._req_app.name = name
        return self

    def folder_token(self, folder_token: str) -> "ReqAppBuilder":
        self._req_app.folder_token = folder_token
        return self

    def time_zone(self, time_zone: str) -> "ReqAppBuilder":
        self._req_app.time_zone = time_zone
        return self

    def build(self) -> "ReqApp":
        return self._req_app
