# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .app_table_create_header import AppTableCreateHeader


class ReqTable(object):
    _types = {
        "name": str,
        "default_view_name": str,
        "fields": List[AppTableCreateHeader],
    }

    def __init__(self, d=None):
        self.name: Optional[str] = None
        self.default_view_name: Optional[str] = None
        self.fields: Optional[List[AppTableCreateHeader]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ReqTableBuilder":
        return ReqTableBuilder()


class ReqTableBuilder(object):
    def __init__(self) -> None:
        self._req_table = ReqTable()

    def name(self, name: str) -> "ReqTableBuilder":
        self._req_table.name = name
        return self

    def default_view_name(self, default_view_name: str) -> "ReqTableBuilder":
        self._req_table.default_view_name = default_view_name
        return self

    def fields(self, fields: List[AppTableCreateHeader]) -> "ReqTableBuilder":
        self._req_table.fields = fields
        return self

    def build(self) -> "ReqTable":
        return self._req_table
