# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .search_app_table_record_request_body import SearchAppTableRecordRequestBody


class SearchAppTableRecordRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.page_token: Optional[str] = None
        self.page_size: Optional[int] = None
        self.app_token: Optional[str] = None
        self.table_id: Optional[str] = None
        self.request_body: Optional[SearchAppTableRecordRequestBody] = None

    @staticmethod
    def builder() -> "SearchAppTableRecordRequestBuilder":
        return SearchAppTableRecordRequestBuilder()


class SearchAppTableRecordRequestBuilder(object):

    def __init__(self) -> None:
        search_app_table_record_request = SearchAppTableRecordRequest()
        search_app_table_record_request.http_method = HttpMethod.POST
        search_app_table_record_request.uri = "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/records/search"
        search_app_table_record_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._search_app_table_record_request: SearchAppTableRecordRequest = search_app_table_record_request

    def user_id_type(self, user_id_type: str) -> "SearchAppTableRecordRequestBuilder":
        self._search_app_table_record_request.user_id_type = user_id_type
        self._search_app_table_record_request.add_query("user_id_type", user_id_type)
        return self

    def page_token(self, page_token: str) -> "SearchAppTableRecordRequestBuilder":
        self._search_app_table_record_request.page_token = page_token
        self._search_app_table_record_request.add_query("page_token", page_token)
        return self

    def page_size(self, page_size: int) -> "SearchAppTableRecordRequestBuilder":
        self._search_app_table_record_request.page_size = page_size
        self._search_app_table_record_request.add_query("page_size", page_size)
        return self

    def app_token(self, app_token: str) -> "SearchAppTableRecordRequestBuilder":
        self._search_app_table_record_request.app_token = app_token
        self._search_app_table_record_request.paths["app_token"] = str(app_token)
        return self

    def table_id(self, table_id: str) -> "SearchAppTableRecordRequestBuilder":
        self._search_app_table_record_request.table_id = table_id
        self._search_app_table_record_request.paths["table_id"] = str(table_id)
        return self

    def request_body(self, request_body: SearchAppTableRecordRequestBody) -> "SearchAppTableRecordRequestBuilder":
        self._search_app_table_record_request.request_body = request_body
        self._search_app_table_record_request.body = request_body
        return self

    def build(self) -> SearchAppTableRecordRequest:
        return self._search_app_table_record_request
