# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .app_table_record import AppTableRecord


class SearchAppTableRecordResponseBody(object):
    _types = {
        "items": AppTableRecord,
        "has_more": bool,
        "page_token": str,
        "total": int,
    }

    def __init__(self, d=None):
        self.items: Optional[AppTableRecord] = None
        self.has_more: Optional[bool] = None
        self.page_token: Optional[str] = None
        self.total: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SearchAppTableRecordResponseBodyBuilder":
        return SearchAppTableRecordResponseBodyBuilder()


class SearchAppTableRecordResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._search_app_table_record_response_body = SearchAppTableRecordResponseBody()

    def items(self, items: AppTableRecord) -> "SearchAppTableRecordResponseBodyBuilder":
        self._search_app_table_record_response_body.items = items
        return self

    def has_more(self, has_more: bool) -> "SearchAppTableRecordResponseBodyBuilder":
        self._search_app_table_record_response_body.has_more = has_more
        return self

    def page_token(self, page_token: str) -> "SearchAppTableRecordResponseBodyBuilder":
        self._search_app_table_record_response_body.page_token = page_token
        return self

    def total(self, total: int) -> "SearchAppTableRecordResponseBodyBuilder":
        self._search_app_table_record_response_body.total = total
        return self

    def build(self) -> "SearchAppTableRecordResponseBody":
        return self._search_app_table_record_response_body
