# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .app_role import AppRole


class UpdateAppRoleRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.app_token: Optional[str] = None
        self.role_id: Optional[str] = None
        self.request_body: Optional[AppRole] = None

    @staticmethod
    def builder() -> "UpdateAppRoleRequestBuilder":
        return UpdateAppRoleRequestBuilder()


class UpdateAppRoleRequestBuilder(object):

    def __init__(self) -> None:
        update_app_role_request = UpdateAppRoleRequest()
        update_app_role_request.http_method = HttpMethod.PUT
        update_app_role_request.uri = "/open-apis/bitable/v1/apps/:app_token/roles/:role_id"
        update_app_role_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._update_app_role_request: UpdateAppRoleRequest = update_app_role_request

    def app_token(self, app_token: str) -> "UpdateAppRoleRequestBuilder":
        self._update_app_role_request.app_token = app_token
        self._update_app_role_request.paths["app_token"] = str(app_token)
        return self

    def role_id(self, role_id: str) -> "UpdateAppRoleRequestBuilder":
        self._update_app_role_request.role_id = role_id
        self._update_app_role_request.paths["role_id"] = str(role_id)
        return self

    def request_body(self, request_body: AppRole) -> "UpdateAppRoleRequestBuilder":
        self._update_app_role_request.request_body = request_body
        self._update_app_role_request.body = request_body
        return self

    def build(self) -> UpdateAppRoleRequest:
        return self._update_app_role_request
