# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .app_table_field import AppTableField


class UpdateAppTableFieldRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.app_token: Optional[str] = None
        self.table_id: Optional[str] = None
        self.field_id: Optional[str] = None
        self.request_body: Optional[AppTableField] = None

    @staticmethod
    def builder() -> "UpdateAppTableFieldRequestBuilder":
        return UpdateAppTableFieldRequestBuilder()


class UpdateAppTableFieldRequestBuilder(object):

    def __init__(self) -> None:
        update_app_table_field_request = UpdateAppTableFieldRequest()
        update_app_table_field_request.http_method = HttpMethod.PUT
        update_app_table_field_request.uri = "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/fields/:field_id"
        update_app_table_field_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._update_app_table_field_request: UpdateAppTableFieldRequest = update_app_table_field_request

    def app_token(self, app_token: str) -> "UpdateAppTableFieldRequestBuilder":
        self._update_app_table_field_request.app_token = app_token
        self._update_app_table_field_request.paths["app_token"] = str(app_token)
        return self

    def table_id(self, table_id: str) -> "UpdateAppTableFieldRequestBuilder":
        self._update_app_table_field_request.table_id = table_id
        self._update_app_table_field_request.paths["table_id"] = str(table_id)
        return self

    def field_id(self, field_id: str) -> "UpdateAppTableFieldRequestBuilder":
        self._update_app_table_field_request.field_id = field_id
        self._update_app_table_field_request.paths["field_id"] = str(field_id)
        return self

    def request_body(self, request_body: AppTableField) -> "UpdateAppTableFieldRequestBuilder":
        self._update_app_table_field_request.request_body = request_body
        self._update_app_table_field_request.body = request_body
        return self

    def build(self) -> UpdateAppTableFieldRequest:
        return self._update_app_table_field_request
