# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_app_role_request import CreateAppRoleRequest
from ..model.create_app_role_response import CreateAppRoleResponse
from ..model.delete_app_role_request import DeleteAppRoleRequest
from ..model.delete_app_role_response import DeleteAppRoleResponse
from ..model.list_app_role_request import ListAppRoleRequest
from ..model.list_app_role_response import ListAppRoleResponse
from ..model.update_app_role_request import UpdateAppRoleRequest
from ..model.update_app_role_response import UpdateAppRoleResponse


class AppRole(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateAppRoleRequest, option: Optional[RequestOption] = None) -> CreateAppRoleResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateAppRoleResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateAppRoleResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateAppRoleRequest,
                      option: Optional[RequestOption] = None) -> CreateAppRoleResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateAppRoleResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateAppRoleResponse)
        response.raw = resp

        return response

    def delete(self, request: DeleteAppRoleRequest, option: Optional[RequestOption] = None) -> DeleteAppRoleResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteAppRoleResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteAppRoleResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeleteAppRoleRequest,
                      option: Optional[RequestOption] = None) -> DeleteAppRoleResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteAppRoleResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteAppRoleResponse)
        response.raw = resp

        return response

    def list(self, request: ListAppRoleRequest, option: Optional[RequestOption] = None) -> ListAppRoleResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListAppRoleResponse = JSON.unmarshal(str(resp.content, UTF_8), ListAppRoleResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListAppRoleRequest, option: Optional[RequestOption] = None) -> ListAppRoleResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListAppRoleResponse = JSON.unmarshal(str(resp.content, UTF_8), ListAppRoleResponse)
        response.raw = resp

        return response

    def update(self, request: UpdateAppRoleRequest, option: Optional[RequestOption] = None) -> UpdateAppRoleResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: UpdateAppRoleResponse = JSON.unmarshal(str(resp.content, UTF_8), UpdateAppRoleResponse)
        response.raw = resp

        return response

    async def aupdate(self, request: UpdateAppRoleRequest,
                      option: Optional[RequestOption] = None) -> UpdateAppRoleResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: UpdateAppRoleResponse = JSON.unmarshal(str(resp.content, UTF_8), UpdateAppRoleResponse)
        response.raw = resp

        return response
