# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.batch_create_app_role_member_request import BatchCreateAppRoleMemberRequest
from ..model.batch_create_app_role_member_response import BatchCreateAppRoleMemberResponse
from ..model.batch_delete_app_role_member_request import BatchDeleteAppRoleMemberRequest
from ..model.batch_delete_app_role_member_response import BatchDeleteAppRoleMemberResponse
from ..model.create_app_role_member_request import CreateAppRoleMemberRequest
from ..model.create_app_role_member_response import CreateAppRoleMemberResponse
from ..model.delete_app_role_member_request import DeleteAppRoleMemberRequest
from ..model.delete_app_role_member_response import DeleteAppRoleMemberResponse
from ..model.list_app_role_member_request import ListAppRoleMemberRequest
from ..model.list_app_role_member_response import ListAppRoleMemberResponse


class AppRoleMember(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def batch_create(self, request: BatchCreateAppRoleMemberRequest,
                     option: Optional[RequestOption] = None) -> BatchCreateAppRoleMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: BatchCreateAppRoleMemberResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                    BatchCreateAppRoleMemberResponse)
        response.raw = resp

        return response

    async def abatch_create(self, request: BatchCreateAppRoleMemberRequest,
                            option: Optional[RequestOption] = None) -> BatchCreateAppRoleMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: BatchCreateAppRoleMemberResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                    BatchCreateAppRoleMemberResponse)
        response.raw = resp

        return response

    def batch_delete(self, request: BatchDeleteAppRoleMemberRequest,
                     option: Optional[RequestOption] = None) -> BatchDeleteAppRoleMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: BatchDeleteAppRoleMemberResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                    BatchDeleteAppRoleMemberResponse)
        response.raw = resp

        return response

    async def abatch_delete(self, request: BatchDeleteAppRoleMemberRequest,
                            option: Optional[RequestOption] = None) -> BatchDeleteAppRoleMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: BatchDeleteAppRoleMemberResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                    BatchDeleteAppRoleMemberResponse)
        response.raw = resp

        return response

    def create(self, request: CreateAppRoleMemberRequest,
               option: Optional[RequestOption] = None) -> CreateAppRoleMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateAppRoleMemberResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateAppRoleMemberResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateAppRoleMemberRequest,
                      option: Optional[RequestOption] = None) -> CreateAppRoleMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateAppRoleMemberResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateAppRoleMemberResponse)
        response.raw = resp

        return response

    def delete(self, request: DeleteAppRoleMemberRequest,
               option: Optional[RequestOption] = None) -> DeleteAppRoleMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteAppRoleMemberResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteAppRoleMemberResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeleteAppRoleMemberRequest,
                      option: Optional[RequestOption] = None) -> DeleteAppRoleMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteAppRoleMemberResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteAppRoleMemberResponse)
        response.raw = resp

        return response

    def list(self, request: ListAppRoleMemberRequest,
             option: Optional[RequestOption] = None) -> ListAppRoleMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListAppRoleMemberResponse = JSON.unmarshal(str(resp.content, UTF_8), ListAppRoleMemberResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListAppRoleMemberRequest,
                    option: Optional[RequestOption] = None) -> ListAppRoleMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListAppRoleMemberResponse = JSON.unmarshal(str(resp.content, UTF_8), ListAppRoleMemberResponse)
        response.raw = resp

        return response
