# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.batch_create_app_table_record_request import BatchCreateAppTableRecordRequest
from ..model.batch_create_app_table_record_response import BatchCreateAppTableRecordResponse
from ..model.batch_delete_app_table_record_request import BatchDeleteAppTableRecordRequest
from ..model.batch_delete_app_table_record_response import BatchDeleteAppTableRecordResponse
from ..model.batch_update_app_table_record_request import BatchUpdateAppTableRecordRequest
from ..model.batch_update_app_table_record_response import BatchUpdateAppTableRecordResponse
from ..model.create_app_table_record_request import CreateAppTableRecordRequest
from ..model.create_app_table_record_response import CreateAppTableRecordResponse
from ..model.delete_app_table_record_request import DeleteAppTableRecordRequest
from ..model.delete_app_table_record_response import DeleteAppTableRecordResponse
from ..model.get_app_table_record_request import GetAppTableRecordRequest
from ..model.get_app_table_record_response import GetAppTableRecordResponse
from ..model.list_app_table_record_request import ListAppTableRecordRequest
from ..model.list_app_table_record_response import ListAppTableRecordResponse
from ..model.search_app_table_record_request import SearchAppTableRecordRequest
from ..model.search_app_table_record_response import SearchAppTableRecordResponse
from ..model.update_app_table_record_request import UpdateAppTableRecordRequest
from ..model.update_app_table_record_response import UpdateAppTableRecordResponse


class AppTableRecord(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def batch_create(self, request: BatchCreateAppTableRecordRequest,
                     option: Optional[RequestOption] = None) -> BatchCreateAppTableRecordResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: BatchCreateAppTableRecordResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     BatchCreateAppTableRecordResponse)
        response.raw = resp

        return response

    async def abatch_create(self, request: BatchCreateAppTableRecordRequest,
                            option: Optional[RequestOption] = None) -> BatchCreateAppTableRecordResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: BatchCreateAppTableRecordResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     BatchCreateAppTableRecordResponse)
        response.raw = resp

        return response

    def batch_delete(self, request: BatchDeleteAppTableRecordRequest,
                     option: Optional[RequestOption] = None) -> BatchDeleteAppTableRecordResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: BatchDeleteAppTableRecordResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     BatchDeleteAppTableRecordResponse)
        response.raw = resp

        return response

    async def abatch_delete(self, request: BatchDeleteAppTableRecordRequest,
                            option: Optional[RequestOption] = None) -> BatchDeleteAppTableRecordResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: BatchDeleteAppTableRecordResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     BatchDeleteAppTableRecordResponse)
        response.raw = resp

        return response

    def batch_update(self, request: BatchUpdateAppTableRecordRequest,
                     option: Optional[RequestOption] = None) -> BatchUpdateAppTableRecordResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: BatchUpdateAppTableRecordResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     BatchUpdateAppTableRecordResponse)
        response.raw = resp

        return response

    async def abatch_update(self, request: BatchUpdateAppTableRecordRequest,
                            option: Optional[RequestOption] = None) -> BatchUpdateAppTableRecordResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: BatchUpdateAppTableRecordResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     BatchUpdateAppTableRecordResponse)
        response.raw = resp

        return response

    def create(self, request: CreateAppTableRecordRequest,
               option: Optional[RequestOption] = None) -> CreateAppTableRecordResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateAppTableRecordResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateAppTableRecordResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateAppTableRecordRequest,
                      option: Optional[RequestOption] = None) -> CreateAppTableRecordResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateAppTableRecordResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateAppTableRecordResponse)
        response.raw = resp

        return response

    def delete(self, request: DeleteAppTableRecordRequest,
               option: Optional[RequestOption] = None) -> DeleteAppTableRecordResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteAppTableRecordResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteAppTableRecordResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeleteAppTableRecordRequest,
                      option: Optional[RequestOption] = None) -> DeleteAppTableRecordResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteAppTableRecordResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteAppTableRecordResponse)
        response.raw = resp

        return response

    def get(self, request: GetAppTableRecordRequest,
            option: Optional[RequestOption] = None) -> GetAppTableRecordResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetAppTableRecordResponse = JSON.unmarshal(str(resp.content, UTF_8), GetAppTableRecordResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetAppTableRecordRequest,
                   option: Optional[RequestOption] = None) -> GetAppTableRecordResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetAppTableRecordResponse = JSON.unmarshal(str(resp.content, UTF_8), GetAppTableRecordResponse)
        response.raw = resp

        return response

    def list(self, request: ListAppTableRecordRequest,
             option: Optional[RequestOption] = None) -> ListAppTableRecordResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListAppTableRecordResponse = JSON.unmarshal(str(resp.content, UTF_8), ListAppTableRecordResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListAppTableRecordRequest,
                    option: Optional[RequestOption] = None) -> ListAppTableRecordResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListAppTableRecordResponse = JSON.unmarshal(str(resp.content, UTF_8), ListAppTableRecordResponse)
        response.raw = resp

        return response

    def search(self, request: SearchAppTableRecordRequest,
               option: Optional[RequestOption] = None) -> SearchAppTableRecordResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: SearchAppTableRecordResponse = JSON.unmarshal(str(resp.content, UTF_8), SearchAppTableRecordResponse)
        response.raw = resp

        return response

    async def asearch(self, request: SearchAppTableRecordRequest,
                      option: Optional[RequestOption] = None) -> SearchAppTableRecordResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: SearchAppTableRecordResponse = JSON.unmarshal(str(resp.content, UTF_8), SearchAppTableRecordResponse)
        response.raw = resp

        return response

    def update(self, request: UpdateAppTableRecordRequest,
               option: Optional[RequestOption] = None) -> UpdateAppTableRecordResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: UpdateAppTableRecordResponse = JSON.unmarshal(str(resp.content, UTF_8), UpdateAppTableRecordResponse)
        response.raw = resp

        return response

    async def aupdate(self, request: UpdateAppTableRecordRequest,
                      option: Optional[RequestOption] = None) -> UpdateAppTableRecordResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: UpdateAppTableRecordResponse = JSON.unmarshal(str(resp.content, UTF_8), UpdateAppTableRecordResponse)
        response.raw = resp

        return response
