# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .message import Message


class CreateMessageRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[Message] = None

    @staticmethod
    def builder() -> "CreateMessageRequestBuilder":
        return CreateMessageRequestBuilder()


class CreateMessageRequestBuilder(object):

    def __init__(self) -> None:
        create_message_request = CreateMessageRequest()
        create_message_request.http_method = HttpMethod.POST
        create_message_request.uri = "/open-apis/block/v2/message"
        create_message_request.token_types = {AccessTokenType.TENANT}
        self._create_message_request: CreateMessageRequest = create_message_request

    def request_body(self, request_body: Message) -> "CreateMessageRequestBuilder":
        self._create_message_request.request_body = request_body
        self._create_message_request.body = request_body
        return self

    def build(self) -> CreateMessageRequest:
        return self._create_message_request
