# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class AttendeeChatMember(object):
    _types = {
        "rsvp_status": str,
        "is_optional": bool,
        "display_name": str,
        "is_organizer": bool,
        "is_external": bool,
    }

    def __init__(self, d=None):
        self.rsvp_status: Optional[str] = None
        self.is_optional: Optional[bool] = None
        self.display_name: Optional[str] = None
        self.is_organizer: Optional[bool] = None
        self.is_external: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AttendeeChatMemberBuilder":
        return AttendeeChatMemberBuilder()


class AttendeeChatMemberBuilder(object):
    def __init__(self) -> None:
        self._attendee_chat_member = AttendeeChatMember()

    def rsvp_status(self, rsvp_status: str) -> "AttendeeChatMemberBuilder":
        self._attendee_chat_member.rsvp_status = rsvp_status
        return self

    def is_optional(self, is_optional: bool) -> "AttendeeChatMemberBuilder":
        self._attendee_chat_member.is_optional = is_optional
        return self

    def display_name(self, display_name: str) -> "AttendeeChatMemberBuilder":
        self._attendee_chat_member.display_name = display_name
        return self

    def is_organizer(self, is_organizer: bool) -> "AttendeeChatMemberBuilder":
        self._attendee_chat_member.is_organizer = is_organizer
        return self

    def is_external(self, is_external: bool) -> "AttendeeChatMemberBuilder":
        self._attendee_chat_member.is_external = is_external
        return self

    def build(self) -> "AttendeeChatMember":
        return self._attendee_chat_member
