# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .calendar_event_attendee_id import CalendarEventAttendeeId


class BatchDeleteCalendarEventAttendeeRequestBody(object):
    _types = {
        "attendee_ids": List[str],
        "delete_ids": List[CalendarEventAttendeeId],
        "need_notification": bool,
        "instance_start_time_admin": str,
        "is_enable_admin": bool,
    }

    def __init__(self, d=None):
        self.attendee_ids: Optional[List[str]] = None
        self.delete_ids: Optional[List[CalendarEventAttendeeId]] = None
        self.need_notification: Optional[bool] = None
        self.instance_start_time_admin: Optional[str] = None
        self.is_enable_admin: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "BatchDeleteCalendarEventAttendeeRequestBodyBuilder":
        return BatchDeleteCalendarEventAttendeeRequestBodyBuilder()


class BatchDeleteCalendarEventAttendeeRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._batch_delete_calendar_event_attendee_request_body = BatchDeleteCalendarEventAttendeeRequestBody()

    def attendee_ids(self, attendee_ids: List[str]) -> "BatchDeleteCalendarEventAttendeeRequestBodyBuilder":
        self._batch_delete_calendar_event_attendee_request_body.attendee_ids = attendee_ids
        return self

    def delete_ids(self,
                   delete_ids: List[CalendarEventAttendeeId]) -> "BatchDeleteCalendarEventAttendeeRequestBodyBuilder":
        self._batch_delete_calendar_event_attendee_request_body.delete_ids = delete_ids
        return self

    def need_notification(self, need_notification: bool) -> "BatchDeleteCalendarEventAttendeeRequestBodyBuilder":
        self._batch_delete_calendar_event_attendee_request_body.need_notification = need_notification
        return self

    def instance_start_time_admin(self,
                                  instance_start_time_admin: str) -> "BatchDeleteCalendarEventAttendeeRequestBodyBuilder":
        self._batch_delete_calendar_event_attendee_request_body.instance_start_time_admin = instance_start_time_admin
        return self

    def is_enable_admin(self, is_enable_admin: bool) -> "BatchDeleteCalendarEventAttendeeRequestBodyBuilder":
        self._batch_delete_calendar_event_attendee_request_body.is_enable_admin = is_enable_admin
        return self

    def build(self) -> "BatchDeleteCalendarEventAttendeeRequestBody":
        return self._batch_delete_calendar_event_attendee_request_body
