# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .customization_option import CustomizationOption


class CalendarAttendeeResourceCustomization(object):
    _types = {
        "index_key": str,
        "input_content": str,
        "options": List[CustomizationOption],
    }

    def __init__(self, d=None):
        self.index_key: Optional[str] = None
        self.input_content: Optional[str] = None
        self.options: Optional[List[CustomizationOption]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CalendarAttendeeResourceCustomizationBuilder":
        return CalendarAttendeeResourceCustomizationBuilder()


class CalendarAttendeeResourceCustomizationBuilder(object):
    def __init__(self) -> None:
        self._calendar_attendee_resource_customization = CalendarAttendeeResourceCustomization()

    def index_key(self, index_key: str) -> "CalendarAttendeeResourceCustomizationBuilder":
        self._calendar_attendee_resource_customization.index_key = index_key
        return self

    def input_content(self, input_content: str) -> "CalendarAttendeeResourceCustomizationBuilder":
        self._calendar_attendee_resource_customization.input_content = input_content
        return self

    def options(self, options: List[CustomizationOption]) -> "CalendarAttendeeResourceCustomizationBuilder":
        self._calendar_attendee_resource_customization.options = options
        return self

    def build(self) -> "CalendarAttendeeResourceCustomization":
        return self._calendar_attendee_resource_customization
