# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .calendar_understand_extra import CalendarUnderstandExtra
from .system_info import SystemInfo


class CalendarUnderstandScenarioContext(object):
    _types = {
        "scenario": str,
        "work_mode": int,
        "extra": CalendarUnderstandExtra,
        "system_info": SystemInfo,
    }

    def __init__(self, d=None):
        self.scenario: Optional[str] = None
        self.work_mode: Optional[int] = None
        self.extra: Optional[CalendarUnderstandExtra] = None
        self.system_info: Optional[SystemInfo] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CalendarUnderstandScenarioContextBuilder":
        return CalendarUnderstandScenarioContextBuilder()


class CalendarUnderstandScenarioContextBuilder(object):
    def __init__(self) -> None:
        self._calendar_understand_scenario_context = CalendarUnderstandScenarioContext()

    def scenario(self, scenario: str) -> "CalendarUnderstandScenarioContextBuilder":
        self._calendar_understand_scenario_context.scenario = scenario
        return self

    def work_mode(self, work_mode: int) -> "CalendarUnderstandScenarioContextBuilder":
        self._calendar_understand_scenario_context.work_mode = work_mode
        return self

    def extra(self, extra: CalendarUnderstandExtra) -> "CalendarUnderstandScenarioContextBuilder":
        self._calendar_understand_scenario_context.extra = extra
        return self

    def system_info(self, system_info: SystemInfo) -> "CalendarUnderstandScenarioContextBuilder":
        self._calendar_understand_scenario_context.system_info = system_info
        return self

    def build(self) -> "CalendarUnderstandScenarioContext":
        return self._calendar_understand_scenario_context
