# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class CreateCalendarEventMeetingChatRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.calendar_id: Optional[str] = None
        self.event_id: Optional[str] = None

    @staticmethod
    def builder() -> "CreateCalendarEventMeetingChatRequestBuilder":
        return CreateCalendarEventMeetingChatRequestBuilder()


class CreateCalendarEventMeetingChatRequestBuilder(object):

    def __init__(self) -> None:
        create_calendar_event_meeting_chat_request = CreateCalendarEventMeetingChatRequest()
        create_calendar_event_meeting_chat_request.http_method = HttpMethod.POST
        create_calendar_event_meeting_chat_request.uri = "/open-apis/calendar/v4/calendars/:calendar_id/events/:event_id/meeting_chat"
        create_calendar_event_meeting_chat_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._create_calendar_event_meeting_chat_request: CreateCalendarEventMeetingChatRequest = create_calendar_event_meeting_chat_request

    def calendar_id(self, calendar_id: str) -> "CreateCalendarEventMeetingChatRequestBuilder":
        self._create_calendar_event_meeting_chat_request.calendar_id = calendar_id
        self._create_calendar_event_meeting_chat_request.paths["calendar_id"] = str(calendar_id)
        return self

    def event_id(self, event_id: str) -> "CreateCalendarEventMeetingChatRequestBuilder":
        self._create_calendar_event_meeting_chat_request.event_id = event_id
        self._create_calendar_event_meeting_chat_request.paths["event_id"] = str(event_id)
        return self

    def build(self) -> CreateCalendarEventMeetingChatRequest:
        return self._create_calendar_event_meeting_chat_request
