# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .calendar import Calendar


class CreateCalendarRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[Calendar] = None

    @staticmethod
    def builder() -> "CreateCalendarRequestBuilder":
        return CreateCalendarRequestBuilder()


class CreateCalendarRequestBuilder(object):

    def __init__(self) -> None:
        create_calendar_request = CreateCalendarRequest()
        create_calendar_request.http_method = HttpMethod.POST
        create_calendar_request.uri = "/open-apis/calendar/v4/calendars"
        create_calendar_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._create_calendar_request: CreateCalendarRequest = create_calendar_request

    def request_body(self, request_body: Calendar) -> "CreateCalendarRequestBuilder":
        self._create_calendar_request.request_body = request_body
        self._create_calendar_request.body = request_body
        return self

    def build(self) -> CreateCalendarRequest:
        return self._create_calendar_request
