# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class DeleteCalendarAclRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.calendar_id: Optional[str] = None
        self.acl_id: Optional[str] = None

    @staticmethod
    def builder() -> "DeleteCalendarAclRequestBuilder":
        return DeleteCalendarAclRequestBuilder()


class DeleteCalendarAclRequestBuilder(object):

    def __init__(self) -> None:
        delete_calendar_acl_request = DeleteCalendarAclRequest()
        delete_calendar_acl_request.http_method = HttpMethod.DELETE
        delete_calendar_acl_request.uri = "/open-apis/calendar/v4/calendars/:calendar_id/acls/:acl_id"
        delete_calendar_acl_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._delete_calendar_acl_request: DeleteCalendarAclRequest = delete_calendar_acl_request

    def calendar_id(self, calendar_id: str) -> "DeleteCalendarAclRequestBuilder":
        self._delete_calendar_acl_request.calendar_id = calendar_id
        self._delete_calendar_acl_request.paths["calendar_id"] = str(calendar_id)
        return self

    def acl_id(self, acl_id: str) -> "DeleteCalendarAclRequestBuilder":
        self._delete_calendar_acl_request.acl_id = acl_id
        self._delete_calendar_acl_request.paths["acl_id"] = str(acl_id)
        return self

    def build(self) -> DeleteCalendarAclRequest:
        return self._delete_calendar_acl_request
