# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class DeleteCalendarEventRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.need_notification: Optional[bool] = None
        self.calendar_id: Optional[str] = None
        self.event_id: Optional[str] = None

    @staticmethod
    def builder() -> "DeleteCalendarEventRequestBuilder":
        return DeleteCalendarEventRequestBuilder()


class DeleteCalendarEventRequestBuilder(object):

    def __init__(self) -> None:
        delete_calendar_event_request = DeleteCalendarEventRequest()
        delete_calendar_event_request.http_method = HttpMethod.DELETE
        delete_calendar_event_request.uri = "/open-apis/calendar/v4/calendars/:calendar_id/events/:event_id"
        delete_calendar_event_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._delete_calendar_event_request: DeleteCalendarEventRequest = delete_calendar_event_request

    def need_notification(self, need_notification: bool) -> "DeleteCalendarEventRequestBuilder":
        self._delete_calendar_event_request.need_notification = need_notification
        self._delete_calendar_event_request.add_query("need_notification", need_notification)
        return self

    def calendar_id(self, calendar_id: str) -> "DeleteCalendarEventRequestBuilder":
        self._delete_calendar_event_request.calendar_id = calendar_id
        self._delete_calendar_event_request.paths["calendar_id"] = str(calendar_id)
        return self

    def event_id(self, event_id: str) -> "DeleteCalendarEventRequestBuilder":
        self._delete_calendar_event_request.event_id = event_id
        self._delete_calendar_event_request.paths["event_id"] = str(event_id)
        return self

    def build(self) -> DeleteCalendarEventRequest:
        return self._delete_calendar_event_request
