# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class DeleteCalendarRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.calendar_id: Optional[str] = None

    @staticmethod
    def builder() -> "DeleteCalendarRequestBuilder":
        return DeleteCalendarRequestBuilder()


class DeleteCalendarRequestBuilder(object):

    def __init__(self) -> None:
        delete_calendar_request = DeleteCalendarRequest()
        delete_calendar_request.http_method = HttpMethod.DELETE
        delete_calendar_request.uri = "/open-apis/calendar/v4/calendars/:calendar_id"
        delete_calendar_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._delete_calendar_request: DeleteCalendarRequest = delete_calendar_request

    def calendar_id(self, calendar_id: str) -> "DeleteCalendarRequestBuilder":
        self._delete_calendar_request.calendar_id = calendar_id
        self._delete_calendar_request.paths["calendar_id"] = str(calendar_id)
        return self

    def build(self) -> DeleteCalendarRequest:
        return self._delete_calendar_request
