# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class DeleteExchangeBindingRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.exchange_binding_id: Optional[str] = None

    @staticmethod
    def builder() -> "DeleteExchangeBindingRequestBuilder":
        return DeleteExchangeBindingRequestBuilder()


class DeleteExchangeBindingRequestBuilder(object):

    def __init__(self) -> None:
        delete_exchange_binding_request = DeleteExchangeBindingRequest()
        delete_exchange_binding_request.http_method = HttpMethod.DELETE
        delete_exchange_binding_request.uri = "/open-apis/calendar/v4/exchange_bindings/:exchange_binding_id"
        delete_exchange_binding_request.token_types = {AccessTokenType.USER}
        self._delete_exchange_binding_request: DeleteExchangeBindingRequest = delete_exchange_binding_request

    def exchange_binding_id(self, exchange_binding_id: str) -> "DeleteExchangeBindingRequestBuilder":
        self._delete_exchange_binding_request.exchange_binding_id = exchange_binding_id
        self._delete_exchange_binding_request.paths["exchange_binding_id"] = str(exchange_binding_id)
        return self

    def build(self) -> DeleteExchangeBindingRequest:
        return self._delete_exchange_binding_request
