# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class EventOrganizer(object):
    _types = {
        "user_id": str,
        "display_name": str,
    }

    def __init__(self, d=None):
        self.user_id: Optional[str] = None
        self.display_name: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "EventOrganizerBuilder":
        return EventOrganizerBuilder()


class EventOrganizerBuilder(object):
    def __init__(self) -> None:
        self._event_organizer = EventOrganizer()

    def user_id(self, user_id: str) -> "EventOrganizerBuilder":
        self._event_organizer.user_id = user_id
        return self

    def display_name(self, display_name: str) -> "EventOrganizerBuilder":
        self._event_organizer.display_name = display_name
        return self

    def build(self) -> "EventOrganizer":
        return self._event_organizer
