# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class FreeTimeSlot(object):
    _types = {
        "start_time": str,
        "end_time": str,
        "length": int,
    }

    def __init__(self, d=None):
        self.start_time: Optional[str] = None
        self.end_time: Optional[str] = None
        self.length: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "FreeTimeSlotBuilder":
        return FreeTimeSlotBuilder()


class FreeTimeSlotBuilder(object):
    def __init__(self) -> None:
        self._free_time_slot = FreeTimeSlot()

    def start_time(self, start_time: str) -> "FreeTimeSlotBuilder":
        self._free_time_slot.start_time = start_time
        return self

    def end_time(self, end_time: str) -> "FreeTimeSlotBuilder":
        self._free_time_slot.end_time = end_time
        return self

    def length(self, length: int) -> "FreeTimeSlotBuilder":
        self._free_time_slot.length = length
        return self

    def build(self) -> "FreeTimeSlot":
        return self._free_time_slot
