# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetExchangeBindingRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.exchange_binding_id: Optional[str] = None

    @staticmethod
    def builder() -> "GetExchangeBindingRequestBuilder":
        return GetExchangeBindingRequestBuilder()


class GetExchangeBindingRequestBuilder(object):

    def __init__(self) -> None:
        get_exchange_binding_request = GetExchangeBindingRequest()
        get_exchange_binding_request.http_method = HttpMethod.GET
        get_exchange_binding_request.uri = "/open-apis/calendar/v4/exchange_bindings/:exchange_binding_id"
        get_exchange_binding_request.token_types = {AccessTokenType.USER}
        self._get_exchange_binding_request: GetExchangeBindingRequest = get_exchange_binding_request

    def user_id_type(self, user_id_type: str) -> "GetExchangeBindingRequestBuilder":
        self._get_exchange_binding_request.user_id_type = user_id_type
        self._get_exchange_binding_request.add_query("user_id_type", user_id_type)
        return self

    def exchange_binding_id(self, exchange_binding_id: str) -> "GetExchangeBindingRequestBuilder":
        self._get_exchange_binding_request.exchange_binding_id = exchange_binding_id
        self._get_exchange_binding_request.paths["exchange_binding_id"] = str(exchange_binding_id)
        return self

    def build(self) -> GetExchangeBindingRequest:
        return self._get_exchange_binding_request
