# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class InstancesCalendarEventRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.start_time: Optional[str] = None
        self.end_time: Optional[str] = None
        self.page_size: Optional[int] = None
        self.page_token: Optional[str] = None
        self.calendar_id: Optional[str] = None
        self.event_id: Optional[str] = None

    @staticmethod
    def builder() -> "InstancesCalendarEventRequestBuilder":
        return InstancesCalendarEventRequestBuilder()


class InstancesCalendarEventRequestBuilder(object):

    def __init__(self) -> None:
        instances_calendar_event_request = InstancesCalendarEventRequest()
        instances_calendar_event_request.http_method = HttpMethod.GET
        instances_calendar_event_request.uri = "/open-apis/calendar/v4/calendars/:calendar_id/events/:event_id/instances"
        instances_calendar_event_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._instances_calendar_event_request: InstancesCalendarEventRequest = instances_calendar_event_request

    def start_time(self, start_time: str) -> "InstancesCalendarEventRequestBuilder":
        self._instances_calendar_event_request.start_time = start_time
        self._instances_calendar_event_request.add_query("start_time", start_time)
        return self

    def end_time(self, end_time: str) -> "InstancesCalendarEventRequestBuilder":
        self._instances_calendar_event_request.end_time = end_time
        self._instances_calendar_event_request.add_query("end_time", end_time)
        return self

    def page_size(self, page_size: int) -> "InstancesCalendarEventRequestBuilder":
        self._instances_calendar_event_request.page_size = page_size
        self._instances_calendar_event_request.add_query("page_size", page_size)
        return self

    def page_token(self, page_token: str) -> "InstancesCalendarEventRequestBuilder":
        self._instances_calendar_event_request.page_token = page_token
        self._instances_calendar_event_request.add_query("page_token", page_token)
        return self

    def calendar_id(self, calendar_id: str) -> "InstancesCalendarEventRequestBuilder":
        self._instances_calendar_event_request.calendar_id = calendar_id
        self._instances_calendar_event_request.paths["calendar_id"] = str(calendar_id)
        return self

    def event_id(self, event_id: str) -> "InstancesCalendarEventRequestBuilder":
        self._instances_calendar_event_request.event_id = event_id
        self._instances_calendar_event_request.paths["event_id"] = str(event_id)
        return self

    def build(self) -> InstancesCalendarEventRequest:
        return self._instances_calendar_event_request
