# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .calendar_acl import CalendarAcl


class ListCalendarAclResponseBody(object):
    _types = {
        "acls": List[CalendarAcl],
        "has_more": bool,
        "page_token": str,
    }

    def __init__(self, d=None):
        self.acls: Optional[List[CalendarAcl]] = None
        self.has_more: Optional[bool] = None
        self.page_token: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListCalendarAclResponseBodyBuilder":
        return ListCalendarAclResponseBodyBuilder()


class ListCalendarAclResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_calendar_acl_response_body = ListCalendarAclResponseBody()

    def acls(self, acls: List[CalendarAcl]) -> "ListCalendarAclResponseBodyBuilder":
        self._list_calendar_acl_response_body.acls = acls
        return self

    def has_more(self, has_more: bool) -> "ListCalendarAclResponseBodyBuilder":
        self._list_calendar_acl_response_body.has_more = has_more
        return self

    def page_token(self, page_token: str) -> "ListCalendarAclResponseBodyBuilder":
        self._list_calendar_acl_response_body.page_token = page_token
        return self

    def build(self) -> "ListCalendarAclResponseBody":
        return self._list_calendar_acl_response_body
