# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListCalendarEventRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.page_size: Optional[int] = None
        self.anchor_time: Optional[str] = None
        self.page_token: Optional[str] = None
        self.sync_token: Optional[str] = None
        self.start_time: Optional[str] = None
        self.end_time: Optional[str] = None
        self.user_id_type: Optional[str] = None
        self.calendar_id: Optional[str] = None

    @staticmethod
    def builder() -> "ListCalendarEventRequestBuilder":
        return ListCalendarEventRequestBuilder()


class ListCalendarEventRequestBuilder(object):

    def __init__(self) -> None:
        list_calendar_event_request = ListCalendarEventRequest()
        list_calendar_event_request.http_method = HttpMethod.GET
        list_calendar_event_request.uri = "/open-apis/calendar/v4/calendars/:calendar_id/events"
        list_calendar_event_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._list_calendar_event_request: ListCalendarEventRequest = list_calendar_event_request

    def page_size(self, page_size: int) -> "ListCalendarEventRequestBuilder":
        self._list_calendar_event_request.page_size = page_size
        self._list_calendar_event_request.add_query("page_size", page_size)
        return self

    def anchor_time(self, anchor_time: str) -> "ListCalendarEventRequestBuilder":
        self._list_calendar_event_request.anchor_time = anchor_time
        self._list_calendar_event_request.add_query("anchor_time", anchor_time)
        return self

    def page_token(self, page_token: str) -> "ListCalendarEventRequestBuilder":
        self._list_calendar_event_request.page_token = page_token
        self._list_calendar_event_request.add_query("page_token", page_token)
        return self

    def sync_token(self, sync_token: str) -> "ListCalendarEventRequestBuilder":
        self._list_calendar_event_request.sync_token = sync_token
        self._list_calendar_event_request.add_query("sync_token", sync_token)
        return self

    def start_time(self, start_time: str) -> "ListCalendarEventRequestBuilder":
        self._list_calendar_event_request.start_time = start_time
        self._list_calendar_event_request.add_query("start_time", start_time)
        return self

    def end_time(self, end_time: str) -> "ListCalendarEventRequestBuilder":
        self._list_calendar_event_request.end_time = end_time
        self._list_calendar_event_request.add_query("end_time", end_time)
        return self

    def user_id_type(self, user_id_type: str) -> "ListCalendarEventRequestBuilder":
        self._list_calendar_event_request.user_id_type = user_id_type
        self._list_calendar_event_request.add_query("user_id_type", user_id_type)
        return self

    def calendar_id(self, calendar_id: str) -> "ListCalendarEventRequestBuilder":
        self._list_calendar_event_request.calendar_id = calendar_id
        self._list_calendar_event_request.paths["calendar_id"] = str(calendar_id)
        return self

    def build(self) -> ListCalendarEventRequest:
        return self._list_calendar_event_request
