# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListCalendarRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.page_size: Optional[int] = None
        self.page_token: Optional[str] = None
        self.sync_token: Optional[str] = None

    @staticmethod
    def builder() -> "ListCalendarRequestBuilder":
        return ListCalendarRequestBuilder()


class ListCalendarRequestBuilder(object):

    def __init__(self) -> None:
        list_calendar_request = ListCalendarRequest()
        list_calendar_request.http_method = HttpMethod.GET
        list_calendar_request.uri = "/open-apis/calendar/v4/calendars"
        list_calendar_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._list_calendar_request: ListCalendarRequest = list_calendar_request

    def page_size(self, page_size: int) -> "ListCalendarRequestBuilder":
        self._list_calendar_request.page_size = page_size
        self._list_calendar_request.add_query("page_size", page_size)
        return self

    def page_token(self, page_token: str) -> "ListCalendarRequestBuilder":
        self._list_calendar_request.page_token = page_token
        self._list_calendar_request.add_query("page_token", page_token)
        return self

    def sync_token(self, sync_token: str) -> "ListCalendarRequestBuilder":
        self._list_calendar_request.sync_token = sync_token
        self._list_calendar_request.add_query("sync_token", sync_token)
        return self

    def build(self) -> ListCalendarRequest:
        return self._list_calendar_request
