# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .calendar import Calendar


class ListCalendarResponseBody(object):
    _types = {
        "has_more": bool,
        "page_token": str,
        "sync_token": str,
        "calendar_list": List[Calendar],
    }

    def __init__(self, d=None):
        self.has_more: Optional[bool] = None
        self.page_token: Optional[str] = None
        self.sync_token: Optional[str] = None
        self.calendar_list: Optional[List[Calendar]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListCalendarResponseBodyBuilder":
        return ListCalendarResponseBodyBuilder()


class ListCalendarResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_calendar_response_body = ListCalendarResponseBody()

    def has_more(self, has_more: bool) -> "ListCalendarResponseBodyBuilder":
        self._list_calendar_response_body.has_more = has_more
        return self

    def page_token(self, page_token: str) -> "ListCalendarResponseBodyBuilder":
        self._list_calendar_response_body.page_token = page_token
        return self

    def sync_token(self, sync_token: str) -> "ListCalendarResponseBodyBuilder":
        self._list_calendar_response_body.sync_token = sync_token
        return self

    def calendar_list(self, calendar_list: List[Calendar]) -> "ListCalendarResponseBodyBuilder":
        self._list_calendar_response_body.calendar_list = calendar_list
        return self

    def build(self) -> "ListCalendarResponseBody":
        return self._list_calendar_response_body
