# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class ListFreebusyRequestBody(object):
    _types = {
        "time_min": str,
        "time_max": str,
        "user_id": str,
        "room_id": str,
        "include_external_calendar": bool,
        "only_busy": bool,
    }

    def __init__(self, d=None):
        self.time_min: Optional[str] = None
        self.time_max: Optional[str] = None
        self.user_id: Optional[str] = None
        self.room_id: Optional[str] = None
        self.include_external_calendar: Optional[bool] = None
        self.only_busy: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListFreebusyRequestBodyBuilder":
        return ListFreebusyRequestBodyBuilder()


class ListFreebusyRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._list_freebusy_request_body = ListFreebusyRequestBody()

    def time_min(self, time_min: str) -> "ListFreebusyRequestBodyBuilder":
        self._list_freebusy_request_body.time_min = time_min
        return self

    def time_max(self, time_max: str) -> "ListFreebusyRequestBodyBuilder":
        self._list_freebusy_request_body.time_max = time_max
        return self

    def user_id(self, user_id: str) -> "ListFreebusyRequestBodyBuilder":
        self._list_freebusy_request_body.user_id = user_id
        return self

    def room_id(self, room_id: str) -> "ListFreebusyRequestBodyBuilder":
        self._list_freebusy_request_body.room_id = room_id
        return self

    def include_external_calendar(self, include_external_calendar: bool) -> "ListFreebusyRequestBodyBuilder":
        self._list_freebusy_request_body.include_external_calendar = include_external_calendar
        return self

    def only_busy(self, only_busy: bool) -> "ListFreebusyRequestBodyBuilder":
        self._list_freebusy_request_body.only_busy = only_busy
        return self

    def build(self) -> "ListFreebusyRequestBody":
        return self._list_freebusy_request_body
