# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .room_meta import RoomMeta
from .user_meta import UserMeta


class MyaiReply(object):
    _types = {
        "reply": str,
        "start_time": str,
        "end_time": str,
        "rooms": List[RoomMeta],
        "summary": str,
        "participants": List[UserMeta],
        "event_id": str,
        "recurrence_rule": str,
    }

    def __init__(self, d=None):
        self.reply: Optional[str] = None
        self.start_time: Optional[str] = None
        self.end_time: Optional[str] = None
        self.rooms: Optional[List[RoomMeta]] = None
        self.summary: Optional[str] = None
        self.participants: Optional[List[UserMeta]] = None
        self.event_id: Optional[str] = None
        self.recurrence_rule: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MyaiReplyBuilder":
        return MyaiReplyBuilder()


class MyaiReplyBuilder(object):
    def __init__(self) -> None:
        self._myai_reply = MyaiReply()

    def reply(self, reply: str) -> "MyaiReplyBuilder":
        self._myai_reply.reply = reply
        return self

    def start_time(self, start_time: str) -> "MyaiReplyBuilder":
        self._myai_reply.start_time = start_time
        return self

    def end_time(self, end_time: str) -> "MyaiReplyBuilder":
        self._myai_reply.end_time = end_time
        return self

    def rooms(self, rooms: List[RoomMeta]) -> "MyaiReplyBuilder":
        self._myai_reply.rooms = rooms
        return self

    def summary(self, summary: str) -> "MyaiReplyBuilder":
        self._myai_reply.summary = summary
        return self

    def participants(self, participants: List[UserMeta]) -> "MyaiReplyBuilder":
        self._myai_reply.participants = participants
        return self

    def event_id(self, event_id: str) -> "MyaiReplyBuilder":
        self._myai_reply.event_id = event_id
        return self

    def recurrence_rule(self, recurrence_rule: str) -> "MyaiReplyBuilder":
        self._myai_reply.recurrence_rule = recurrence_rule
        return self

    def build(self) -> "MyaiReply":
        return self._myai_reply
