# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .calendar_event import CalendarEvent


class PatchCalendarEventRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.calendar_id: Optional[str] = None
        self.event_id: Optional[str] = None
        self.request_body: Optional[CalendarEvent] = None

    @staticmethod
    def builder() -> "PatchCalendarEventRequestBuilder":
        return PatchCalendarEventRequestBuilder()


class PatchCalendarEventRequestBuilder(object):

    def __init__(self) -> None:
        patch_calendar_event_request = PatchCalendarEventRequest()
        patch_calendar_event_request.http_method = HttpMethod.PATCH
        patch_calendar_event_request.uri = "/open-apis/calendar/v4/calendars/:calendar_id/events/:event_id"
        patch_calendar_event_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._patch_calendar_event_request: PatchCalendarEventRequest = patch_calendar_event_request

    def user_id_type(self, user_id_type: str) -> "PatchCalendarEventRequestBuilder":
        self._patch_calendar_event_request.user_id_type = user_id_type
        self._patch_calendar_event_request.add_query("user_id_type", user_id_type)
        return self

    def calendar_id(self, calendar_id: str) -> "PatchCalendarEventRequestBuilder":
        self._patch_calendar_event_request.calendar_id = calendar_id
        self._patch_calendar_event_request.paths["calendar_id"] = str(calendar_id)
        return self

    def event_id(self, event_id: str) -> "PatchCalendarEventRequestBuilder":
        self._patch_calendar_event_request.event_id = event_id
        self._patch_calendar_event_request.paths["event_id"] = str(event_id)
        return self

    def request_body(self, request_body: CalendarEvent) -> "PatchCalendarEventRequestBuilder":
        self._patch_calendar_event_request.request_body = request_body
        self._patch_calendar_event_request.body = request_body
        return self

    def build(self) -> PatchCalendarEventRequest:
        return self._patch_calendar_event_request
