# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class PrimaryCalendarRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None

    @staticmethod
    def builder() -> "PrimaryCalendarRequestBuilder":
        return PrimaryCalendarRequestBuilder()


class PrimaryCalendarRequestBuilder(object):

    def __init__(self) -> None:
        primary_calendar_request = PrimaryCalendarRequest()
        primary_calendar_request.http_method = HttpMethod.POST
        primary_calendar_request.uri = "/open-apis/calendar/v4/calendars/primary"
        primary_calendar_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._primary_calendar_request: PrimaryCalendarRequest = primary_calendar_request

    def user_id_type(self, user_id_type: str) -> "PrimaryCalendarRequestBuilder":
        self._primary_calendar_request.user_id_type = user_id_type
        self._primary_calendar_request.add_query("user_id_type", user_id_type)
        return self

    def build(self) -> PrimaryCalendarRequest:
        return self._primary_calendar_request
